#include "POF/NN_data.h"

void init_nndata(struct NN_data** p_nndata){
	std::unique_ptr<NN_data> new_p_nndata(new NN_data);
	*p_nndata = new_p_nndata.release();
}

void print_nndata(struct NN_data* nn_data){	
	cout<<nn_data->n_class<<endl;
	cout<<nn_data->n_internal_test_case<<endl;
	cout<<nn_data->batch_size<<endl;
	cout<<nn_data->test_case_ccon_w[0][0][0]<<endl;
	cout<<nn_data->ccon_w[0][0][0]<<endl;
	cout<<nn_data->ans_sum[0][0]<<endl;
	cout<<nn_data->ans_sum[0][1]<<endl;
}

void get_bias(struct NN_data* nn_data, double* bias) {
	*bias = nn_data->bias;
}

// void copy_normalclass(struct NN_data* target_nn_data, struct NN_data* source_nn_data) {
// 	for (int pm = 0; pm < n_label; pm++) {
// 		for (int j = 0; j < nn_data->batch_size; j++) {
// 			double max = -5000000;
// 			for (int i = 0; i < nn_data->n_class; i++) {
// 				if (nn_data->ccon_w[pm][i][j] > max) {
// 					nn_data->normalclass[pm][j] = i;
// 					max = nn_data->ccon_w[pm][i][j];
// 				}
// 			}
// 		}
// 	}
// 	memcpy(target_nn_data->normalclass, )
// }

void set_normalclass(struct NN_data* nn_data) {
	memset(nn_data->normalclass, 0, sizeof(nn_data->normalclass));
	for (int pm = 0; pm < n_label; pm++) {
		for (int j = 0; j < nn_data->batch_size; j++) {
			double max = -5000000;
			for (int i = 0; i < nn_data->n_class; i++) {
				if (nn_data->ccon_w[pm][i][j] > max) {
					nn_data->normalclass[pm][j] = i;
					max = nn_data->ccon_w[pm][i][j];
				}
			}
		}
	}
}

void update_train_nndata(int batch_size, int n_class, double objective_list[], double ccon_w_list[], struct NN_data* nn_data) {
	memset(nn_data->objective, 0, sizeof(nn_data->objective));
	memset(nn_data->ccon_w, 0, sizeof(nn_data->ccon_w));
	
	nn_data->batch_size = batch_size;
	nn_data->n_class = n_class;
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < batch_size; j++) {
			nn_data->objective[i][j] = objective_list[i*batch_size + j];
		}
	}
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < n_class; j++) {
			for (int k = 0; k < batch_size; k++) {
				nn_data->ccon_w[i][j][k] = ccon_w_list[i*batch_size*n_class + k*n_class + j]; 
			}
		}
	}
	for (int i = 0; i < n_label; i++) {
		for (int k = 0; k < batch_size; k++) {
			nn_data->ccon_w[i][0][k] += nn_data->bias; 
		}
	}

	set_normalclass(nn_data);
}

void update_intest_nndata(int n_internal_test_case, int n_class, int ans_list[], double test_case_ccon_w_list[], struct NN_data* nn_data) {
	memset(nn_data->ans, 0, sizeof(nn_data->ans));
	memset(nn_data->ans_sum, 0, sizeof(nn_data->ans_sum));
	memset(nn_data->test_case_ccon_w, 0, sizeof(nn_data->test_case_ccon_w));

	nn_data->n_internal_test_case = n_internal_test_case;
	nn_data->n_class = n_class;
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < n_internal_test_case; j++) {
			nn_data->ans[i][j] = ans_list[i*n_internal_test_case + j];
			nn_data->ans_sum[i][ans_list[i*n_internal_test_case + j]]++;
		}
	}
	cout<<"ans end"<<endl;
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < n_class; j++) {
			for (int k = 0; k < n_internal_test_case; k++) {
				nn_data->test_case_ccon_w[i][j][k] = test_case_ccon_w_list[i*n_internal_test_case*n_class + k*n_class + j];
			}
		}
	}
}

void update_nndata(int batch_size, int n_internal_test_case, int n_class, double objective_list[], int ans_list[], double ccon_w_list[], double test_case_ccon_w_list[], struct NN_data* nn_data) {
	update_train_nndata(batch_size, n_class, objective_list, ccon_w_list, nn_data);
	update_intest_nndata(n_internal_test_case, n_class, ans_list, test_case_ccon_w_list, nn_data);
}